//------------------------------------------------------------------------------
// File: client_taskstringtable.cs
// This file is adds and removes strings to/from the client's task string table
// Author: Matthew Rudge
//------------------------------------------------------------------------------

////////////////////////////////////////////////////////////////////////////////
//! Base function that adds or removes a string to/from a string table.  Task 
//! strings are displayed to the client only if they are in the string table.
//! \param %bAdd True if adding a string to the table, false if removing
//! \param %strId String id for string to add to table
//! \param %str   String to add to table (not needed on remove)
////////////////////////////////////////////////////////////////////////////////
function slgUpdateTaskStrings(%bAdd, %strId, %str)
{
   if(%bAdd) {
      slgAddTaskStr(%strId, %str);
   }
   else {
      slgRemoveTaskStr(%strId);
   }
}


// End client_taskstringtable.cs